

/******************************************************************************************************
 **                                                                                                  **
 **                     EX1 : PlotDot (for ET-DISPLAY 8x32RED)                                       **
 **                     Use : Dot-Matrix(8x8=4 digit) #LDM1088A ,Drive #Max7219                      **
 **                                                                                                  ** 
 ******************************************************************************************************
 **                                                                                                  **
 **  Target MCU         :   AVR Easy Mega 328 (ET-CPU DISPLAY8x32)                                   **
 **                     :   X-TAL : 16 MHz                                                           ** 
 **                                                                                                  **
 **  Editor/Compiler    :   Arduino 1.8.1                                                            **
 **                                                                                                  **                   
 **  Port Interface    :   Arduino Mega328 PIN                        Device Interface               **
 **                         ----------------------                     --------------                **                      
 **  Dot-Matrix         :   Pin D10-OUT (PB2)                           CS/Load-Max7219              **
 **                         Pin D11-OUT (PB3)                           DIN-Max7219                  **
 **                         Pin D12-OUT (PB4)                           CLK-Max7219K                 **
 **                                                                                                  **                                                                                                 
 ** Buzzer output Port  :   Pin D6(PD6)                                 Buzzer(Act=1)                **   
 **  Create By          :   Mr.Sittiphol Yooyod (WWW.ETT.CO.TH)                                      **
 **  Last Update        :   7/December/2018                                                          ** 
 **                                                                                                  ** 
 ******************************************************************************************************/

// MAX7219 commands:
#define CMD_NOOP   0
#define CMD_DIGIT0 1
#define CMD_DIGIT1 2
#define CMD_DIGIT2 3
#define CMD_DIGIT3 4
#define CMD_DIGIT4 5
#define CMD_DIGIT5 6
#define CMD_DIGIT6 7
#define CMD_DIGIT7 8
#define CMD_DECODEMODE  9
#define CMD_INTENSITY   10
#define CMD_SCANLIMIT   11
#define CMD_SHUTDOWN    12
#define CMD_DISPLAYTEST 15

#define NUM_MAX      4    //Number Max7219 4 Ship

//----------Buzzer------------
#define BUZZER_PIN   6

/************ Define Pin **************/

//--Dot Matrix Pin for Max7219----
#define CS_PIN       10
#define DIN_PIN      11
#define CLK_PIN      12

                               //Colum      0       1      2        3
static byte ScrBuf[8][4] = {   //Position  DSP0   -DSP1    -DSP2   -DSP3       
                    {0,0,0,0},    //data   D8-D0   D8-D0   D8-D0   D8-D0  ---Row0(A0) 
                    {0,0,0,0},    //data   D8-D0   D8-D0   D8-D0   D8-D0
                    {0,0,0,0},             
                    {0,0,0,0},
                    {0,0,0,0},
                    {0,0,0,0},
                    {0,0,0,0},
                    {0,0,0,0}    //data   D8-D0   D8-D0   D8-D0   D8-D0   ---Row7(A7)
                  };           //Ex Font   'A'



const unsigned char dot[] PROGMEM = {0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //data Pattern 8x8
                                     0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
                                    
                                    };
                                     
const unsigned char BClr[] PROGMEM = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}; //data Clear Buffer

/*************************************************************************
 **    Function : Sent Command+Data 2Byte(16Bit) to Max7219 4-Ship      **
 *************************************************************************/            
  
void SendCmdAll(byte cmd, byte data)
{
  int dp ;
  
  digitalWrite(CS_PIN, LOW);
  
  for(dp=0 ; dp< NUM_MAX ; dp++)                 //Loop 4 round for Max7219 4 Ship
   {
     shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, cmd) ; //Shift command 8 bit byte High(D15-D8)
     shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, data); //Shift Data 8 bit byte Low(D7-D0) 
   }

  digitalWrite(CS_PIN, LOW);
  digitalWrite(CS_PIN, HIGH);
}



/****************************************************************
 **       Function : Refress Screen All (4 Display=8x32 Dot)   **
 ****************************************************************/       

void RefreshAll() 
{
  char rw,dp  ;
  
  //------------- Refresh Screen All --------------------------
  
  for (rw = 0; rw < 8 ; rw++)  //Loop Scan 8 Row  Start A0-A7 
   {
    digitalWrite(CS_PIN, LOW);
    
    for(dp = 3 ; dp >= 0 ; dp--) //Loop NUM_MAX=4 (0-3)
     {
      shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, CMD_DIGIT0 + rw)   ; //Shift cmm 8bit byte High (Row Address Start Row 0(Ver.))
      shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, ScrBuf[rw][dp])    ; //Shift data 8bit byte Low (Sent Serial data Start Buffer[row0][Colum3]
     }
    digitalWrite(CS_PIN, LOW);
    digitalWrite(CS_PIN, HIGH);                                 //Latch Data to Display
   }

  
}



/**************************************************************************************************************
 **                           Function : Plot data to Screen Buffer                                          **      
 **************************************************************************************************************           
 **  Paramiter :                                                                                             **
 **              dsp = Position dsp buffer 0-3 for keep data                                                 **                                                      
 **       *name_font = Name Table font                                                                       **      
 **                                                                                                          **
 **************************************************************************************************************/
 
void PlotDot(char dsp, const unsigned char *name_font)
{
  byte dt ;
  char row ;
    
      for(row=0;row<8;row++)                  //Loop Number Byte Data of 1 Charecter row 0-7
       {
         dt = pgm_read_byte(name_font+row) ;   //Read Data 1 Byte of font from 8 Byte

           ScrBuf[row][dsp] = dt           ;   //update Data 1 byte of Charecter to buffer colume Dsp 4 colum 
       } //for row
 
} //End Show Number



/********************************************************
 **            Function:Initial Max7219                **
 ********************************************************/          
void InitMAX7219()
{
  pinMode(DIN_PIN, OUTPUT)         ;   //D11
  pinMode(CLK_PIN, OUTPUT)         ;   //D13
  pinMode(CS_PIN, OUTPUT)          ;   //D10
  digitalWrite(CS_PIN, HIGH)       ;
  digitalWrite(CLK_PIN, LOW)       ;  //****************
    
  SendCmdAll(CMD_DISPLAYTEST, 0)   ;  //Set Display Normal Mode
  SendCmdAll(CMD_SCANLIMIT, 7)     ;  //Set Scan 8 digit is 100 HZ 
  SendCmdAll(CMD_DECODEMODE, 0)    ;
  SendCmdAll(CMD_INTENSITY, 15)    ; //Bright Max=15 ,Min=0
  SendCmdAll(CMD_SHUTDOWN, 0)      ;

  RefreshAll()                     ; 
  SendCmdAll(CMD_SHUTDOWN,1)       ;

}



/****************************************************
 *            Function : Buzzer Beep                *
 ****************************************************/

 void Beep(unsigned int dd)
  {
    digitalWrite(BUZZER_PIN,true)   ;     //Buzzer ON
    delay(dd)     ;
    digitalWrite(BUZZER_PIN,false)   ;     //Buzzer OFF
  }





// ########################## Setup ####################################

void setup() 
{
  pinMode(BUZZER_PIN, OUTPUT)         ;   //D6-Buzzer
  digitalWrite(BUZZER_PIN,LOW)        ;   //Buzzer = 0 OFF
   
  InitMAX7219();
}
 
// ########################## Main Program #############################

void loop()
{ 
  //---pattern1----
   PlotDot(0,dot)  ;  //Plot data to ScrBuf DSP0
   RefreshAll()    ;
   PlotDot(0,BClr) ;  //Clear ScrBuf DSP0
   delay(500)      ;
   
   PlotDot(1,dot)  ; //Plot data to ScrBuf DSP1
   RefreshAll()    ;
   PlotDot(1,BClr) ; //Clear ScrBuf DSP1
   delay(500)      ;
   
   PlotDot(2,dot)  ;//Plot data to ScrBuf DSP2
   RefreshAll()    ;
   PlotDot(2,BClr) ; //Clear ScrBuf DSP2
   delay(500)      ;
  
   PlotDot(3,dot)  ; //Plot data to ScrBuf DSP3
   RefreshAll()    ;
   PlotDot(3,BClr) ; //Clear ScrBuf DSP3
   delay(500)      ;

   Beep(200)         ;
   Beep(100)         ;
   
  //---pattern2----
   PlotDot(0,dot+8)  ;  //Position Start data dot array[8]
   RefreshAll()      ;
   PlotDot(0,BClr)   ; //Clear ScrBuf DSP0
   delay(500)        ;
   
   PlotDot(1,dot+8)  ;
   RefreshAll()      ;
   PlotDot(1,BClr)   ; //Clear ScrBuf DSP1
   delay(500)        ;
   
   PlotDot(2,dot+8)  ;
   RefreshAll()      ;
   PlotDot(2,BClr)   ; //Clear ScrBuf DSP2
   delay(500)        ;
      
   PlotDot(3,dot+8) ;
   RefreshAll()     ;
   PlotDot(3,BClr)  ; //Clear ScrBuf DSP3
   delay(500)       ;


}  // end void







